<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:import href="Strings.xsl"/>
	<xsl:output method="html" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" encoding="UTF-8" indent="yes"/>		
	
	<!-- Template for generating the main report. The main entry point for the transformation. -->
	<xsl:template name="LeftFrame" match="/">
		<html>
			<head>
				<title>
					<xsl:value-of select="/FMPReport/File/@linkTOCFrame"/>
				</title>			
			</head>
			<body>
				<p>
					<span class="regularcharttext">
						<br/><br/><br/>
						<xsl:call-template name="ExternalLink-NoAnchor-WithTarget">
							<xsl:with-param name="inFileLink" select="concat('./../',/FMPReport/@link)"/>
							<xsl:with-param name="inTarget" select="'_top'"/>
							<xsl:with-param name="inDisplayText" select="$valBackToOverview"/>
						</xsl:call-template>						
					</span>
				</p>
				<span class="regularcharttext">
					<hr width="100%"/>
					<xsl:call-template name="ExternalLink-NoAnchor-WithTarget">
						<xsl:with-param name="inFileLink" select="concat(/FMPReport/File/@linkReportFrame,'#', 'valFileOptionOverview',$kAnchorSection)"/>
						<xsl:with-param name="inTarget" select="'main'"/>
						<xsl:with-param name="inDisplayText" select="$valFileOptionOverview"/>
					</xsl:call-template>
					<xsl:if test="/FMPReport/File/BaseTableCatalog/BaseTable">
						<br/>
						<xsl:call-template name="ExternalLink-NoAnchor-WithTarget">
							<xsl:with-param name="inFileLink" select="concat(/FMPReport/File/@linkReportFrame,'#', 'valTables',$kAnchorSection)"/>
							<xsl:with-param name="inTarget" select="'main'"/>
							<xsl:with-param name="inDisplayText" select="$valTables"/>
						</xsl:call-template>														
					</xsl:if>	
					<xsl:if test="/FMPReport/File/BaseTableCatalog/BaseTable/FieldCatalog/Field">
						<br/>
						<xsl:call-template name="ExternalLink-NoAnchor-WithTarget">
							<xsl:with-param name="inFileLink" select="concat(/FMPReport/File/@linkReportFrame,'#', 'valFields',$kAnchorSection)"/>
							<xsl:with-param name="inTarget" select="'main'"/>
							<xsl:with-param name="inDisplayText" select="$valFields"/>
						</xsl:call-template>														
					</xsl:if>
					
					<xsl:if test="/FMPReport/File/RelationshipGraph">
						<br/>	
						<xsl:value-of select="$valRelationships"/>												
			
						<xsl:if test="/FMPReport/File/RelationshipGraph/TableList">
							<br/>
							&#xa0;&#xa0;&#xa0;
							<xsl:call-template name="ExternalLink-NoAnchor-WithTarget">
								<xsl:with-param name="inFileLink" select="concat(/FMPReport/File/@linkReportFrame,'#', 'valRelationships',$kAnchorSection)"/>
								<xsl:with-param name="inTarget" select="'main'"/>
								<xsl:with-param name="inDisplayText" select="$valTableOccurrences"/>
							</xsl:call-template>							
						</xsl:if>
						<xsl:if test="/FMPReport/File/RelationshipGraph/RelationshipList/Relationship">
							<br/>
							&#xa0;&#xa0;&#xa0;
							<xsl:call-template name="ExternalLink-NoAnchor-WithTarget">
								<xsl:with-param name="inFileLink" select="concat(/FMPReport/File/@linkReportFrame,'#', 'valDetails',$kAnchorSection)"/>
								<xsl:with-param name="inTarget" select="'main'"/>
								<xsl:with-param name="inDisplayText" select="$valDetails"/>
							</xsl:call-template>								
						</xsl:if>
					</xsl:if>

					<xsl:if test="/FMPReport/File/LayoutCatalog/Layout">
						<br/>
						<xsl:call-template name="ExternalLink-NoAnchor-WithTarget">
							<xsl:with-param name="inFileLink" select="concat(/FMPReport/File/@linkReportFrame,'#', 'valLayouts',$kAnchorSection)"/>
							<xsl:with-param name="inTarget" select="'main'"/>
							<xsl:with-param name="inDisplayText" select="$valLayouts"/>
						</xsl:call-template>						
					</xsl:if>
					<xsl:if test="/FMPReport/File/ValueListCatalog/ValueList">
						<br/>
						<xsl:call-template name="ExternalLink-NoAnchor-WithTarget">
							<xsl:with-param name="inFileLink" select="concat(/FMPReport/File/@linkReportFrame,'#', 'valValueLists',$kAnchorSection)"/>
							<xsl:with-param name="inTarget" select="'main'"/>
							<xsl:with-param name="inDisplayText" select="$valValueLists"/>
						</xsl:call-template>						
					</xsl:if>
					<xsl:if test="/FMPReport/File/ScriptCatalog/Script or /FMPReport/File/ScriptCatalog/Group">
						<br/>
						<xsl:call-template name="ExternalLink-NoAnchor-WithTarget">
							<xsl:with-param name="inFileLink" select="concat(/FMPReport/File/@linkReportFrame,'#', 'valScripts',$kAnchorSection)"/>
							<xsl:with-param name="inTarget" select="'main'"/>
							<xsl:with-param name="inDisplayText" select="$valScripts"/>
						</xsl:call-template>						
					</xsl:if>
					
  				<xsl:if test="/FMPReport/File/AccountCatalog or /FMPReport/File/PrivilegesCatalog or /FMPReport/File/ExtendedPrivilegeCatalog or /FMPReport/File/AuthFileCatalog">
						<br/>
						<xsl:value-of select="$valSecurity"/>

						<xsl:if test="/FMPReport/File/AccountCatalog/Account">
							<br/>
							&#xa0;&#xa0;&#xa0;
							<xsl:call-template name="ExternalLink-NoAnchor-WithTarget">
								<xsl:with-param name="inFileLink" select="concat(/FMPReport/File/@linkReportFrame,'#', 'valAccounts',$kAnchorSection)"/>
								<xsl:with-param name="inTarget" select="'main'"/>
								<xsl:with-param name="inDisplayText" select="$valAccounts"/>
							</xsl:call-template>							
						</xsl:if>
						<xsl:if test="/FMPReport/File/PrivilegesCatalog/PrivilegeSet">
							<br/>
							&#xa0;&#xa0;&#xa0;
							<xsl:call-template name="ExternalLink-NoAnchor-WithTarget">
								<xsl:with-param name="inFileLink" select="concat(/FMPReport/File/@linkReportFrame,'#', 'valPrivilegeSets',$kAnchorSection)"/>
								<xsl:with-param name="inTarget" select="'main'"/>
								<xsl:with-param name="inDisplayText" select="$valPrivilegeSets"/>
							</xsl:call-template>						
						</xsl:if>
						<xsl:if test="/FMPReport/File/ExtendedPrivilegeCatalog/ExtendedPrivilege">
							<br/>
							&#xa0;&#xa0;&#xa0;
							<xsl:call-template name="ExternalLink-NoAnchor-WithTarget">
								<xsl:with-param name="inFileLink" select="concat(/FMPReport/File/@linkReportFrame,'#', 'valExtendedPrivileges',$kAnchorSection)"/>
								<xsl:with-param name="inTarget" select="'main'"/>
								<xsl:with-param name="inDisplayText" select="$valExtendedPrivileges"/>
							</xsl:call-template>						
						</xsl:if>
						<xsl:if test="/FMPReport/File/AuthFileCatalog">
							<br/>
							&#xa0;&#xa0;&#xa0;
							<xsl:call-template name="ExternalLink-NoAnchor-WithTarget">
								<xsl:with-param name="inFileLink" select="concat(/FMPReport/File/@linkReportFrame,'#', 'valFileAccess', $kAnchorSection)"/>
								<xsl:with-param name="inTarget" select="'main'"/>
								<xsl:with-param name="inDisplayText" select="$valFileAccess"/>
							</xsl:call-template>
						</xsl:if>
					</xsl:if>
					
					<xsl:if test="/FMPReport/File/CustomFunctionCatalog/CustomFunction">
						<br/>
						<xsl:call-template name="ExternalLink-NoAnchor-WithTarget">
							<xsl:with-param name="inFileLink" select="concat(/FMPReport/File/@linkReportFrame,'#', 'valCustomFunctions',$kAnchorSection)"/>
							<xsl:with-param name="inTarget" select="'main'"/>
							<xsl:with-param name="inDisplayText" select="$valCustomFunctions"/>
						</xsl:call-template>						
					</xsl:if>
					<xsl:if test="/FMPReport/File/FileReferenceCatalog/FileReference or /FMPReport/File/FileReferenceCatalog/OdbcDataSource">
						<br/>
						<xsl:call-template name="ExternalLink-NoAnchor-WithTarget">
							<xsl:with-param name="inFileLink" select="concat(/FMPReport/File/@linkReportFrame,'#', 'valFileReferences',$kAnchorSection)"/>
							<xsl:with-param name="inTarget" select="'main'"/>
							<xsl:with-param name="inDisplayText" select="$valDataSources"/>
						</xsl:call-template>						
					</xsl:if>	
					<xsl:if test="/FMPReport/File/CustomMenuSetCatalog/CustomMenuSet">
						<br/>
						<xsl:call-template name="ExternalLink-NoAnchor-WithTarget">
							<xsl:with-param name="inFileLink" select="concat(/FMPReport/File/@linkReportFrame,'#', 'valCustomMenuSets',$kAnchorSection)"/>
							<xsl:with-param name="inTarget" select="'main'"/>
							<xsl:with-param name="inDisplayText" select="$valCustomMenuSets"/>
						</xsl:call-template>						
					</xsl:if>	
					<xsl:if test="/FMPReport/File/CustomMenuCatalog/CustomMenu">
						<br/>
						<xsl:call-template name="ExternalLink-NoAnchor-WithTarget">
							<xsl:with-param name="inFileLink" select="concat(/FMPReport/File/@linkReportFrame,'#', 'valCustomMenus',$kAnchorSection)"/>
							<xsl:with-param name="inTarget" select="'main'"/>
							<xsl:with-param name="inDisplayText" select="$valCustomMenus"/>
						</xsl:call-template>						
					</xsl:if>		
				</span> 
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
